<?php

namespace \App\Models\Application;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'application_user';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function application()
	{
		return $this->belongsTo('App\Models\Application');
	}

	public function role()
	{
		return $this->hasOne('\App\Models\Application\User\Role');
	}

	public function acl()
	{
		return $this->hasMany('\App\Models\Application\User\Role\Acl', 'application_user_role_id', 'application_user_role_id');
	}

}