<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAclTable extends Migration {

	public function up()
	{
		Schema::create('acl', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('ressource', 255)->index();
			$table->enum('rules', array('deny', 'read', 'create', 'update', 'delete'));
			$table->integer('application_user_id');
			$table->integer('application_user_role_id');
		});
	}

	public function down()
	{
		Schema::drop('acl');
	}
}