<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationFieldTable extends Migration {

	public function up()
	{
		Schema::create('application_field', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('application_id');
			$table->string('name', 255);
			$table->enum('type', array('text', 'hidden', 'password', 'number', 'datetime', 'date', 'select', 'checkbox', 'radio', 'textarea'));
			$table->string('label', 255);
			$table->boolean('isRequired');
			$table->text('attributs');
			$table->integer('module_id');
			$table->text('condition');
			$table->boolean('inListing');
			$table->boolean('isSearchable');
			$table->integer('application_tabs_id');
			$table->string('location', 255);
		});
	}

	public function down()
	{
		Schema::drop('application_field');
	}
}