<?php

namespace \App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'event';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function state()
	{
		return $this->hasMany('App\Models\Event\State');
	}

	public function date()
	{
		return $this->hasMany('App\Models\Event\Date');
	}

	public function product()
	{
		return $this->hasMany('App\Models\Event\Product2');
	}

}