<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApplicationUserTable extends Migration {

	public function up()
	{
		Schema::create('application_user', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('application_id');
			$table->string('login', 255);
			$table->string('password', 255);
			$table->string('name', 255);
			$table->integer('application_user_role_id');
			$table->string('secret_key', 255);
			$table->string('bearer_token', 255);
		});
	}

	public function down()
	{
		Schema::drop('application_user');
	}
}