<?php

class Meeting extends Eloquent {

	protected $table = 'MEETING_meeting';
	public $timestamps = false;

	public function issue()
	{
		return $this->hasMany('Issue', 'meeting_id');
	}

	public function group()
	{
		return $this->belongsTo('Group', 'meeting_id');
	}

	public function personas()
	{
		return $this->belongsToMany('Personas', 'persona_id')->withPivot('rol_id','attend');
	}

	public function file()
	{
		return $this->hasMany('File', 'meeting_id');
	}

}