<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Task extends Model 
{

    protected $table = 'tasks';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function moderator()
    {
        return $this->belongsTo('app\User');
    }

    public function status()
    {
        return $this->morphToMany('app\Statusable');
    }

    public function ctegories()
    {
        return $this->morphToMany('app\Categoryable');
    }

    public function media()
    {
        return $this->morphMany('app\Media');
    }

    public function meta()
    {
        return $this->morphMany('app\Meta');
    }

}