<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Status extends Model 
{

    protected $table = 'statuses';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function tasks()
    {
        return $this->morphedByMany('app\Statusable');
    }

    public function products()
    {
        return $this->morphedByMany('app\Statusable');
    }

    public function orders()
    {
        return $this->morphedByMany('app\Statusable');
    }

}