<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->foreign('moderator_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('categoriables', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statusables', function(Blueprint $table) {
			$table->foreign('status_id')->references('id')->on('statuses')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('dictitems', function(Blueprint $table) {
			$table->foreign('dict_id')->references('id')->on('dictionaries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orderitems', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('tasks', function(Blueprint $table) {
			$table->dropForeign('tasks_moderator_id_foreign');
		});
		Schema::table('categoriables', function(Blueprint $table) {
			$table->dropForeign('categoriables_category_id_foreign');
		});
		Schema::table('statusables', function(Blueprint $table) {
			$table->dropForeign('statusables_status_id_foreign');
		});
		Schema::table('dictitems', function(Blueprint $table) {
			$table->dropForeign('dictitems_dict_id_foreign');
		});
		Schema::table('orderitems', function(Blueprint $table) {
			$table->dropForeign('orderitems_order_id_foreign');
		});
	}
}