<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function author()
	{
		return $this->belongsTo('User');
	}

	public function status()
	{
		return $this->morphToMany('app\Statusable');
	}

	public function categories()
	{
		return $this->morphToMany('app\Categoryable');
	}

	public function tags()
	{
		return $this->morphToMany('app\Taggable');
	}

	public function media()
	{
		return $this->morphMany('app\Media');
	}

	public function meta()
	{
		return $this->morphMany('app\Meta');
	}

	public function amount()
	{
		return $this->belongsToMany('app\Orderitem');
	}

}