<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Status extends Eloquent {

	protected $table = 'statuses';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tasks()
	{
		return $this->morphedByMany('app\Statusable');
	}

	public function products()
	{
		return $this->morphedByMany('app\Statusable');
	}

	public function orders()
	{
		return $this->morphedByMany('app\Statusable');
	}

}