<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Category extends Eloquent {

	protected $table = 'categories';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function tasks()
	{
		return $this->morphedByMany('app\Categoryable');
	}

	public function products()
	{
		return $this->morphedByMany('app\Categoryable');
	}

	public function dictionaries()
	{
		return $this->morphedByMany('app\Categoryable');
	}

	public function media()
	{
		return $this->morphMany('app\Media');
	}

}