<?php

namespace app;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Orderitem extends Eloquent {

	protected $table = 'orderitems';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function product()
	{
		return $this->hasOne('app\Product');
	}

	public function order()
	{
		return $this->belongsTo('app\Order');
	}

}