<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dictionary extends Model 
{

    protected $table = 'dictionaries';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categories()
    {
        return $this->morphToMany('app\Categoryable');
    }

    public function items()
    {
        return $this->hasMany('app\Dictitem');
    }

    public function fields()
    {
        return $this->hasMany('app\Dictdata');
    }

    public function media()
    {
        return $this->morphMany('app\Media');
    }

    public function meta()
    {
        return $this->morphMany('app\Meta');
    }

}