<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function author()
    {
        return $this->belongsTo('User');
    }

    public function status()
    {
        return $this->morphToMany('app\Statusable');
    }

    public function categories()
    {
        return $this->morphToMany('app\Categoryable');
    }

    public function tags()
    {
        return $this->morphToMany('app\Taggable');
    }

    public function media()
    {
        return $this->morphMany('app\Media');
    }

    public function meta()
    {
        return $this->morphMany('app\Meta');
    }

    public function amount()
    {
        return $this->belongsToMany('app\Orderitem');
    }

}