<?php

namespace app;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function author()
    {
        return $this->belongsTo('app\User');
    }

    public function status()
    {
        return $this->morphToMany('app\Statusable');
    }

}