<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('model_id')->unsigned();
			$table->string('model_type');
			$table->string('collection_name');
			$table->string('name');
			$table->string('file_name');
			$table->string('mime_type');
			$table->string('disk');
			$table->integer('size')->unsigned();
			$table->text('manipulations');
			$table->string('custom_properties');
			$table->integer('order_column')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}