<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSettingsTable extends Migration {

	public function up()
	{
		Schema::create('settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191);
			$table->string('slug')->unique();
			$table->text('value')->nullable();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('settings');
	}
}