<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 191)->nullable();
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->string('image', 191)->nullable();
			$table->boolean('status')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}