<?php

namespace App/Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = false;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'email', 'phone', 'password', 'type');

    public function sportPage()
    {
        return $this->belongsTo('App/Models\User', 'user_id');
    }

    public function sportPage()
    {
        return $this->hasMany('App/Models\User', 'user_id');
    }

}