<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBankInformationsTable extends Migration {

	public function up()
	{
		Schema::create('bank_informations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('beneficiary_name');
			$table->string('account_number');
			$table->string('bank_name');
			$table->string('swift_code');
			$table->string('iban');
			$table->string('iban_certificate');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('bank_informations');
	}
}