<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateGymsTable extends Migration {

	public function up()
	{
		Schema::create('gyms', function(Blueprint $table) {
			$table->increments('id');
			$table->string('manager_identity', 20);
			$table->json('fields')->nullable();
			$table->json('facilities');
			$table->time('start_work');
			$table->time('end_work');
			$table->string('off_days');
			$table->bigInteger('user_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('gyms');
	}
}