<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function trainer()
	{
		return $this->hasOne('Trainer');
	}

	public function gym()
	{
		return $this->hasOne('Gym');
	}

	public function nutritionist()
	{
		return $this->hasOne('Nutritionist');
	}

	public function restaurant()
	{
		return $this->hasOne('Restaurant');
	}

	public function bank_information()
	{
		return $this->hasOne('BankInformation');
	}

	public function packages()
	{
		return $this->hasMany('Package');
	}

	public function coupons()
	{
		return $this->hasMany('Coupon');
	}

	public function availability()
	{
		return $this->hasOne('Availability');
	}

	public function packageSubscriptions()
	{
		return $this->hasMany('PackageSubscription');
	}

	public function copuonSubscriptions()
	{
		return $this->hasMany('CouponSubscriptions');
	}

}