<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Users extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('given_name', 'last_name', 'google_id', 'email', 'username');

    public function meals()
    {
        return $this->hasMany('App\MealPlanner');
    }

}