<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->string('id_hash', 40)->unique();
			$table->integer('companies_id')->unsigned();
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 256);
			$table->integer('package_unit_id')->unsigned();
			$table->integer('package_weight')->nullable();
			$table->decimal('price', 5,2);
			$table->integer('price_unit_id')->unsigned();
			$table->integer('price_unit_cost')->unsigned()->nullable();
			$table->string('description', 1024)->nullable();
			$table->string('wholesalers_stockcode', 16);
			$table->boolean('is_on_special')->default(0);
			$table->boolean('is_in_stock')->default(1);
			$table->integer('item_count')->default('1');
			$table->decimal('price_was', 5,2);
			$table->decimal('price_savings', 5,2);
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}