<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Items extends Model 
{

    protected $table = 'items';
    public $timestamps = false;
    protected $fillable = array('title', 'keep_unit_id', 'keep_time_max', 'keep_amount_min');

    public function ingredients()
    {
        return $this->hasMany('App\Ingredients', 'items_id', 'id');
    }

    public function products()
    {
        return $this->hasManyThrough('App\Products', 'App\ProductItems', 'product_id', 'id', 'id', 'items_id');
    }

    public function keep_unit()
    {
        return $this->hasOne('App\UnitMeasurements', 'id', 'keep_unit_id');
    }

    public function meats()
    {
        return $this->hasMany('App\Meats', 'items_id', 'id');
    }

    public function sides()
    {
        return $this->hasMany('App\Sides', 'items_id', 'id');
    }

    public function dressings()
    {
        return $this->hasMany('App\Dressings', 'items_id', 'id');
    }

}