<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sides extends Model 
{

    protected $table = 'sides';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'items_id');

    public function recipes()
    {
        return $this->hasManyThrough('App\Recipes', 'App\RecipeSides', 'recipe_id', 'id', 'id', 'sides_id');
    }

    public function items()
    {
        return $this->belongsTo('App\Items', 'id', 'items_id');
    }

}