<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUnitMeasurementsTable extends Migration {

	public function up()
	{
		Schema::create('unit_measurements', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 32)->unique();
			$table->string('symbol', 10);
			$table->string('symbol_read', 10);
			$table->decimal('worth', 8,4);
			$table->string('regex', 100);
			$table->integer('relative_to_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('unit_measurements');
	}
}