<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Ingredients extends Model 
{

    protected $table = 'ingredients';
    public $timestamps = false;
    protected $fillable = array('items_id', 'title', 'density');

    public function recipes()
    {
        return $this->hasManyThrough('App\Recipes', 'App\RecipeIngredients', 'recipe_id', 'id', 'id', 'ingredients_id');
    }

    public function item()
    {
        return $this->belongsTo('App\Items', 'id', 'items_id');
    }

}