<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MealPlanner extends Model 
{

    protected $table = 'meal_planner';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'recipe_id', 'user_id');

    public function recipe()
    {
        return $this->hasOne('App\Recipes');
    }

    public function user()
    {
        return $this->hasOne('App\Users');
    }

}