<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Dressings extends Model 
{

    protected $table = 'dressings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'items_id');

    public function recipes()
    {
        return $this->hasManyThrough('App\Recipes', 'App\RecipeDressings', 'recipe_id', 'id', 'id', 'dressings_id');
    }

    public function items()
    {
        return $this->belongsTo('App\Items', 'id', 'items_id');
    }

}