<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRecipesTable extends Migration {

	public function up()
	{
		Schema::create('recipes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('id_hash', 40)->unique();
			$table->timestamps();
			$table->softDeletes();
			$table->string('title', 256);
			$table->text('description')->nullable();
			$table->integer('servings')->unsigned();
			$table->integer('cooking_time')->unsigned()->nullable();
			$table->integer('difficulty')->unsigned()->nullable();
			$table->text('prep_notes')->nullable();
			$table->text('instructions')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('recipes');
	}
}