<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateParticipantsTable extends Migration {

	public function up()
	{
		Schema::create('participants', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('visit_id')->unsigned()->index();
			$table->string('email');
			$table->enum('status', array('received', 'accepted', 'declined'));
			$table->text('decline_reason')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('participants');
	}
}