<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitsTable extends Migration {

	public function up()
	{
		Schema::create('visits', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('visitor_id')->unsigned()->index();
			$table->string('name');
			$table->date('date');
			$table->time('time');
			$table->text('desc');
			$table->integer('status')->unsigned()->default('0');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('visits');
	}
}