<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVisitorsTable extends Migration {

	public function up()
	{
		Schema::create('visitors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('username', 191)->unique();
			$table->string('email', 191)->unique();
			$table->string('password');
			$table->string('phone', 15);
			$table->string('company_name')->nullable();
			$table->string('company_address')->nullable();
			$table->string('company_post_code')->nullable();
			$table->integer('verified')->default('0');
			$table->timestamps();
			$table->softDeletes();
			$table->string('token');
		});
	}

	public function down()
	{
		Schema::drop('visitors');
	}
}