<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantsTable extends Migration {

	public function up()
	{
		Schema::create('restaurants', function(Blueprint $table) {
			$table->increments('id');
			$table->string('unique_code', 20);
			$table->tinyInteger('is_enabled')->default('1');
			$table->tinyInteger('is_featured')->default('0');
			$table->tinyInteger('is_pickup')->default('0');
			$table->integer('sequence')->default('0');
			$table->string('email', 255);
			$table->float('rd_commission_value', 10,3)->default('0');
			$table->float('jd_commission_value', 10,3)->default('0');
			$table->tinyInteger('rd_commission_type')->default('1');
			$table->tinyInteger('jd_commission_type')->default('1');
			$table->tinyInteger('commission_from')->default('0');
			$table->tinyInteger('delivery_pay')->default('1');
			$table->float('registration_fees', 10,3);
			$table->tinyInteger('is_trial')->default('0');
			$table->date('trial_end_date');
			$table->date('live_on_date');
			$table->tinyInteger('same_day_delivery')->default('1');
			$table->tinyInteger('food_type')->default('1');
			$table->tinyInteger('status')->default('1');
			$table->string('cover_image', 255);
			$table->string('logo_image', 255);
			$table->string('mobile', 255);
			$table->string('phone', 255);
			$table->integer('accept_time')->default('3');
			$table->integer('prep_time')->default('1');
			$table->string('website', 255);
			$table->tinyInteger('is_catering')->default('0');
			$table->float('avg_order_imit', 10,3)->default('30');
			$table->string('contact1', 255);
			$table->string('contact2', 255);
			$table->tinyInteger('has_delivery')->default('0');
			$table->tinyInteger('pick_time_settings');
			$table->integer('pickup_min_time')->default('5');
			$table->integer('pickup_max_time');
			$table->tinyInteger('delivery_type')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('restaurants');
	}
}