<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRestaurantActivationsTable extends Migration {

	public function up()
	{
		Schema::create('restaurant_activations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('restaurant_id')->unsigned();
			$table->float('fees', 10,3);
			$table->date('start_date');
			$table->date('end_date');
			$table->tinyInteger('current')->default('1');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('restaurant_activations');
	}
}