<?php

namespace App\Addresses;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Country extends Eloquent {

	protected $table = 'countries';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('is_default', 'is_enabled', 'code', 'logo', 'image');

	public function translations()
	{
		return $this->hasMany('App\Addresses\CountryTranslation');
	}

}