<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateHitLogsTable extends Migration {

	public function up()
	{
		Schema::create('hit_logs', function(Blueprint $table) {
			$table->increments('id');
			$table->string('url', 255)->nullable();
			$table->string('url_specific_param', 255)->nullable();
			$table->string('ip', 255)->nullable();
			$table->string('user_agent', 255)->nullable();
			$table->string('session_id', 255)->nullable();
			$table->integer('entity_type')->unsigned()->nullable();
			$table->integer('entity_id')->unsigned()->nullable();
			$table->integer('user_id')->unsigned()->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('hit_logs');
	}
}