<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('action_id')->unsigned()->nullable();
			$table->string('amount', 100)->nullable();
			$table->string('otp', 1000)->nullable();
			$table->string('ip', 20)->nullable();
			$table->enum('status', array('succeeded', 'failed'));
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoices');
	}
}