<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('cell_number', 20)->nullable();
			$table->enum('cell_operator', array('MCI', 'MTN'))->nullable();
			$table->enum('operator_type', array('credit', 'permanent'));
			$table->string('status', 10)->default('disable');
			$table->string('name', 300)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}