<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Flux extends Model 
{

    protected $table = 'fluxes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function image()
    {
        return $this->hasOne('Image');
    }

    public function users()
    {
        return $this->belongsToMany('User');
    }

    public function groups()
    {
        return $this->belongsToMany('FluxGroup');
    }

}