<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTwitterAccountsTable extends Migration {

	public function up()
	{
		Schema::create('twitter_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->string('account');
			$table->integer('occurence_last_24_hours')->nullable();
			$table->integer('occurence_last_7_days');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('source_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('twitter_accounts');
	}
}