<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FluxGroup extends Model 
{

    protected $table = 'flux_groups';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function image()
    {
        return $this->hasOne('Image');
    }

    public function fluxes()
    {
        return $this->belongsToMany('Flux');
    }

}