<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Source extends Model 
{

    protected $table = 'sources';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function categories()
    {
        return $this->belongsToMany('SourceCategory')sources_categories;
    }

    public function image()
    {
        return $this->hasOne('Image');
    }

    public function media()
    {
        return $this->hasOne('SourceMedia');
    }

}