<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFluxesTable extends Migration {

	public function up()
	{
		Schema::create('fluxes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->integer('image_id')->nullable();
			$table->boolean('frequency_all')->nullable();
			$table->boolean('frequency_important')->nullable();
			$table->boolean('frequency_timeslot');
			$table->boolean('frequency_fixed_hour');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('fluxes');
	}
}