<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;
	protected $fillable = array('name', 'Resumes', 'telegram', 'field', 'phone');

	public function accepteds_works()
	{
		return $this->belongsToMany('Work', 'accepteds')->withTimestamps();
	}

	public function applicants_works()
	{
		return $this->belongsToMany('Work', 'applicants')->withTimestamps();
	}

	public function works()
	{
		return $this->hasMany('Work');
	}

	public function ambiguitys_works()
	{
		return $this->belongsToMany('Work', 'ambiguity_user_work')->withPivot('ambiguity_id')->withTimestamps();
	}

	public function ambiguitys()
	{
		return $this->belongsToMany('Ambiguity', 'ambiguity_user_work')->withPivot('work_id')->withTimestamps();
	}

	public function opnion4me_works()
	{
		return $this->belongsToMany('Work', 'opnion_user_work')->withPivot('opnion_id')->withTimestamps();
	}

	public function opnions4me()
	{
		return $this->belongsToMany('Opinion', 'opnion_user_work')->withPivot('work_id')->withTimestamps();
	}

	public function favorite_fields()
	{
		return $this->belongsToMany('Field', 'field_user')->withTimestamps();
	}

	public function favorite_branchs()
	{
		return $this->belongsToMany('Branch', 'branch_user')->withTimestamps();
	}

}