<?php

class Branch extends Eloquent {

	protected $table = 'branchs';
	public $timestamps = true;
	protected $fillable = array('name');

	public function fields()
	{
		return $this->belongsToMany('Field', 'branch_field')->withTimestamps();
	}

	public function users()
	{
		return $this->belongsToMany('User', 'branch_user')->withTimestamps();
	}

	public function works()
	{
		return $this->hasManyThrough('Work', 'field');
	}

}