<?php

class Work extends Eloquent {

	protected $table = 'works';
	public $timestamps = true;
	protected $fillable = array('subject', 'details', 'deadtime', 'filename', 'wage', 'status');

	public function accepteds_users()
	{
		return $this->belongsToMany('User', 'accepteds')->withTimestamps();
	}

	public function applicants_users()
	{
		return $this->belongsToMany('User', 'applicants')->withTimestamps();
	}

	public function user()
	{
		return $this->belongsTo('User');
	}

	public function fields()
	{
		return $this->belongsToMany('Field', 'field_work')->withTimestamps();
	}

	public function ambiguitys_users()
	{
		return $this->belongsToMany('User', 'ambiguity_user_work')->withPivot('ambiguity_id')->withTimestamps();
	}

	public function ambiguitys()
	{
		return $this->belongsToMany('Ambiguity', 'ambiguity_user_work')->withPivot('user_id')->withTimestamps();
	}

	public function opnions()
	{
		return $this->belongsToMany('Opinion', 'opnion_user_work')->withPivot('user_id')->withTimestamps();
	}

	public function opnions_users()
	{
		return $this->belongsToMany('User', 'opnion_user_work')->withPivot('opnion_id')->withTimestamps();
	}

	public function tags()
	{
		return $this->belongsToMany('Tag', 'tag_work')->withTimestamps();
	}

}