<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserMetadataTable extends Migration {

	public function up()
	{
		Schema::create('user_metadata', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('key', 255)->nullable()->index();
			$table->text('value')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_metadata');
	}
}